<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CPortfolioWidgetProjectsWCarousel extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "2",
		"name"	=> "Projects w/ Carousel",
	);

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		switch ($widget["settings"]["set_type"]) {
			default:
			case "1":
				$order = " i.item_date DESC ";
				$cnt = $widget["settings"]["set_items"];
			break;
			

			case "2":
				$order = " rand() ";
				$cnt = $widget["settings"]["set_items"];
			break;

			case "3":

				if (!$widget["settings"]["set_item"]) {
					return "";
				}
				
				$cond = " AND i.item_id IN ({$widget[settings][set_item]}) ";
				$order = "item_date ASC";

				$cnt = 99999;
			break;

			case "4":
				$order = " i.item_date ASC ";
				$cnt = $widget["settings"]["set_items"];
			break;

		}


		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:portfolio_cats']} as c,
				{$this->tables['plugin:portfolio_cats_lang']} as l,
				{$this->tables['plugin:portfolio_items']} as i,
				{$this->tables['plugin:portfolio_items_lang']} as il
			WHERE 				
				c.cat_id=l.cat_id AND 
				l.lang_id={$widget[lang_id]} AND 
				c.module_id={$widget[widget_module]} AND 
				c.cat_status = 1 AND

				i.item_cat=c.cat_id AND 
				i.item_id=il.item_id AND 
				il.lang_id={$widget[lang_id]} AND 
				i.module_id={$widget[widget_module]} AND 
				item_status = 1

			ORDER BY  {$order} 
			LIMIT {$cnt}" 
		);


		if (!is_array($items)) {
			return "";
		}

		if ($widget["settings"]["set_type"] == "3") {
			$items = SortByKeys($items , "item_id" , $widget["settings"]["set_item"]);
		}

		$cats = $this->module->GetCats($widget);


		$elements = explode("," , $widget["settings"]["set_elements"]);

		//$items = $this->ProcessItems($items);
		foreach ($items as $key => $val) {

			$items[$key]["_title"] = $items[$key]["_cats"] = $items[$key]["_brief"] = "";

			if (in_array("title" , $elements)) {
				$items[$key]["_title"] = $this->tpl->blockreplace(
					"Title",
					$val
				);
			} 				

			if (in_array("brief" , $elements) && $val["item_brief"]) {
				$val["item_brief"] = nl2br($val["item_brief"]);

				$items[$key]["_brief"] = $this->tpl->blockreplace(
					"Brief",
					$val
				);
			} 				

			if (in_array("cats" , $elements)) {
				$tmp = explode("," , $val["item_cat"]);
				$_cats = array();

				foreach ($tmp as $k => $v) {
					$_cats[] = $cats[$v];
				}				

				$items[$key]["link"] = $widget["link"] . $val["item_url"] . "/{$val[item_id]}";

				$items[$key]["_cats"] = $base->html->table(
					$this->tpl,
					"ItemCats",
					$_cats
				);
			}

		}
		
		return $this->tpl->blockReplace(
			"Main",
			array(
				"items"	=> $base->html->Table(
					$this->tpl, 
					"" , 
					$items
				),
				"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),

			),
			$widget,
			$widget["settings"]
		);

	}
	
}


?>